#include "Core.h"

#if BLADENSOUL

void DecryptBladeAndSoul(byte* CompressedBuffer, int CompressedSize)
{
	if (CompressedSize >= 32)
	{
		static const char *key = "qiffjdlerdoqymvketdcl0er2subioxq";
		for (int i = 0; i < CompressedSize; i++)
			CompressedBuffer[i] ^= key[i % 32];
	}
}

#endif // BLADENSOUL

#if TAO_YUAN

void DecryptTaoYuan(byte* CompressedBuffer, int CompressedSize)
{
	static const byte key[] =
	{
		137, 35, 95, 142, 69, 136, 243, 119, 25, 35, 111, 94, 101, 136, 243, 204,
		243, 67, 95, 158, 69, 106, 107, 187, 237, 35, 103, 142, 72, 142, 243
	};
	for (int i = 0; i < CompressedSize; i++)
		CompressedBuffer[i] ^= key[i % 31];		// note: "N % 31" is not the same as "N & 0x1F"
}

#endif // TAO_YUAN

#if DEVILS_THIRD

void DecryptDevlsThird(byte* CompressedBuffer, int CompressedSize)
{
	static const byte key[] =
	{
		173,  80,  59,  89,  90,  93,  51,  92, 234, 166,  88, 167, 237,  40, 244, 144,
		155, 111,  96, 112,  80,  48,  62,  94,  15,  58, 182, 196, 238, 145, 247,  47,
		109, 238, 111, 174,  45, 158, 111,  32, 148, 109, 122, 107,  33, 136, 212, 248,
		174, 116, 223,   8,  49,  42, 238, 157, 163,  51, 183,  87,  96, 176,  96, 213,
		136,  75,   7, 196, 251,   2,  66, 132,   2, 116, 166, 106,  69, 112, 101, 125,
		165, 219,  79, 139, 243, 244, 149, 139, 255, 248, 117, 134, 176, 143, 255,  77,
		220, 231, 194, 241, 242,  83, 202, 223,  11, 107, 128,  92, 248, 151, 111, 103,
		 51, 152, 213, 227,   6,  80, 149,  83, 241,  22,  74, 170, 199,  61, 148,  72,
		127, 174, 174,  64, 152,  93,  34,  87, 183, 183, 230, 131,  33,  63, 213, 243,
		221, 140,  40,   1, 188, 252,  98, 223, 147,  20, 134, 108, 242, 196,  41, 236,
		 76, 154,  36, 123,  47,  25, 173,  12,  98, 155,  15,  54, 197,  14,  76, 223,
		161, 168,  85, 171, 129,   6,   7,  67, 105, 215,  45, 159, 124, 131, 208, 123,
		181, 146, 233, 178,  62,  64, 237, 181, 114, 180,  22,  78, 124, 111, 215,  63,
		  0, 209,  79, 101,  99,  74, 159, 185,  43,  80, 153,  95, 101, 102, 255,  27,
		139,   7,  74, 158, 236, 102,  75, 235, 203,  37,  20, 221, 199, 121, 174,  91,
		200, 160, 133, 142,  30,  98,  23, 214,  25,  92, 192,  27,  14, 216,  58, 220,
		 87, 184, 192, 142, 184, 151, 158,  33,  20,  25, 156,  39, 197,  48,  84, 135,
		 91, 179,  60, 134, 184,  79, 148, 209, 174,  22,   3, 123, 193,  52, 159, 145,
		198,  59, 164,  27,  28,  23,  63, 152, 189, 200,  23, 233,  42,  61, 150,  84,
		 83,  64, 190,  38,  45, 226,  89,  42,  26, 128, 208,  92, 222, 188, 188,  12,
		 98,   8,  90, 181, 232, 195,  17, 245, 163, 250, 227, 126, 185, 128,   0, 161,
		199,  38,  12,  27, 247, 181,  19, 228, 221,  42,  67, 129,  35, 232, 133,  93,
		 83, 225,  48, 235,  97, 134,  79, 183, 114,  70, 166, 132,  87,  99, 142, 174,
		  7, 210, 230,  62, 169, 131,  60, 158, 129,  59,  82,  69, 106, 196,  99,  10,
		  4, 171, 235, 213,  80,  19, 133, 149, 100,  62, 250,  45,  82,  95, 139, 180,
		 59, 136, 211, 212,  91, 123,  82, 119, 209,   4, 123, 189,  65,  27, 233, 141,
		112,  34,  96, 128,  71, 211, 146, 140,  85, 187, 253, 124,  27,  41,  29, 109,
		 21,  67,  59, 229, 105, 126,  30,  59, 128, 125, 236,  51,  40,  61,  91, 111,
		214, 242,   6, 194, 243,  82, 194, 136, 144,  37, 134, 132, 207, 114, 207, 183,
		171, 236, 158, 228, 217,  33, 112, 109,  83, 207, 220, 185, 161,  56, 146, 117,
		148, 250,   8, 112, 166, 196, 133, 108, 206,  61, 253, 127,  76,  91, 214,  71,
		 83, 165, 248,  73, 232, 121, 243, 168, 210,  69, 239,  28, 120, 167, 226, 110,
		 38,  72, 207,  42, 189, 190,  47, 218, 222, 228,  94,  79,  94, 143, 178,   2,
		215, 235, 240,  40, 219, 185, 105, 162, 210, 161, 122,   8,   8,  72, 181,  54,
		  2, 103,  49, 159, 205, 203, 243, 229,  11, 255, 174, 251, 181, 196, 105, 177,
		200, 254, 227, 230,  66, 159, 244, 134, 221, 223,  67, 194, 247, 103, 203,   8,
		177, 214,  89,   8, 225, 178,  40, 195, 147, 231,  94,   6,  95, 247,  47,  41,
		186,  58, 173,  84,  21,   3, 134, 159, 200, 199, 227, 130, 167, 251, 253,  93,
		167, 230, 161, 188,  58, 121, 253, 139,  41,  45,  28,  70,  47,  34,   7, 195,
		234,  57, 172,  92,  61, 218, 229,  16, 106, 240,  34, 118, 197,   4,  15,  74,
		104, 233, 149,  55, 230,  23,  13,  83,  37,  70,  80,  76, 217, 152,  22, 198,
		138, 225,  52, 105, 216, 215, 115, 170, 156,  83, 100, 232, 119,  43, 213, 248,
		 62, 171,  28, 151,  73, 151,  57, 154, 227, 243,  62, 140, 235, 242,   5,  44,
		143, 123,  62, 207, 209, 161, 222, 169, 140,  47, 110,  47,  74,  38, 223,  49,
		210, 173, 187, 164,  37, 144,  61, 198,  22, 144,  44, 168, 103, 198, 197,  16,
		135,  27,  32, 203,   4,  74, 107,   7, 117, 192, 104,  93, 230,  91,  77, 152,
		244,  67,  55,   0, 194,  16,  12, 173, 125, 239, 239, 162, 160,  37, 216, 251,
		220, 169, 141,   1, 131,  82,  44,  91, 172,
	};
	static_assert(ARRAY_COUNT(key) == 761, "Bad key");
	uint32 XorIndex = 244109 * CompressedSize + 240169;
    for (int i = 0; i < CompressedSize; i++)
	{
		CompressedBuffer[i] ^= key[XorIndex % 761];
		XorIndex = XorIndex % 761 + 1;
	}
}

#endif // DEVILS_THIRD
